/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: RS232ConfigDlg.h 13422 2019-12-09 09:50:47Z Robert $:

  Description:
    Default Dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2019-12-09  Update file header to actual version
    2009-11-27  Review
    2009-07-28  initial version

**************************************************************************************/

/*****************************************************************************/
/*! \file RS232ConfigDlg.h
*   Configuration dialog for the RS232 connector                             */
/*****************************************************************************/

/* prevent multiple inclusion */
#pragma once

#include "RS232Config.h"

/*****************************************************************************/
/*! \addtogroup netX_CONNECTOR_RS232 netX RS232 Connector                    */
/*! \{                                                                       */
/*****************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \class CRS232ConfigDlg
/// Configuration dialog for the RS232 connector
///////////////////////////////////////////////////////////////////////////////////////////
class CRS232ConfigDlg
{
public:

  static CRS232ConfigDlg* GetInstance           ( void);

  HWND                    Create                ( HWND        hWndParent,
                                                  const char* szConfig = NULL);

  HWND                    GetWindowHandle       ( void) { return m_hDialogWnd;}

  long                    GetConfiguration      ( CString& csRet);
  long                    SetConfiguration      ( const char* szConfig);

  void                    Destroy               ( void);

protected:

  void                    ReadFromDialogItems   ( NX_CONF_KEY_SCOPE_E eKeyScope, 
                                                  CONFIGKEY_MAP&      cmKeyMap);

  void                    WriteToDialogItems    ( NX_CONF_KEY_SCOPE_E eKeyScope,
                                                  CONFIGKEY_MAP&      cmKeyMap); 

  void                    SetLayerDlgItemState      (void);
  void                    SetInterfaceDlgItemState  (void);
  void                    ShowSelInterfaceConfig( void);
  void                    ShowLayerConfig       ( void);

  CString                 GetSelInterfaceName   ( void);

  void                    InitUpDownControl     ( void);
  void                    PopulateComboBoxes    ( void);
  void                    SetComboBox           ( int iItemId, const char* szValue);

         INT_PTR CALLBACK DialogProc            ( HWND hDlg, 
                                                  UINT message, 
                                                  WPARAM wParam, 
                                                  LPARAM lParam);

  static INT_PTR CALLBACK DialogProcStatic      ( HWND hDlg, 
                                                  UINT message, 
                                                  WPARAM wParam, 
                                                  LPARAM lParam);

  CRS232Config            m_cRS232Config;         /*!< Pointer to configuration object     */

  HWND                    m_hDialogWnd;           /*!< Window handle of the default dialog */
  
private:
  // Constructor
  CRS232ConfigDlg();

  // Destructor
  ~CRS232ConfigDlg();

  // Copy constructor
  CRS232ConfigDlg(const CRS232ConfigDlg& cRS232ConfigDlg);
  
  static CRS232ConfigDlg* s_cInstance;            /*!< Pointer to single object instance */
};

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/
